/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.theme.internal;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.scope.IScopeSelector;
import com.aptana.scope.ScopeSelector;
import com.aptana.theme.IThemeManager;
import com.aptana.theme.Theme;
import com.aptana.theme.ThemePlugin;
import com.aptana.theme.ThemeRule;
import com.aptana.theme.internal.Messages;
import com.aptana.theme.internal.OrderedProperties;
import com.aptana.ui.util.UIUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.internal.preferences.Base64;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.DataFormatException;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;
import org.osgi.framework.Bundle;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThemeManager
implements IThemeManager {
    public static final String THEMES_NODE = "themes";
    private volatile Theme fCurrentTheme;
    private Set<String> fBuiltins;
    private Set<String> fThemeNames;
    private static ThemeManager fgInstance;
    private static final String[] annotationKeyPrefixes;

    static {
        annotationKeyPrefixes = new String[]{"pydevOccurrenceIndication", "searchResultIndication", "xmlTagPairOccurrenceIndication", "htmlTagPairOccurrenceIndication", "rubyBlockPairOccurrenceIndication"};
    }

    private ThemeManager() {
        InstanceScope.INSTANCE.getNode("org.eclipse.ui.editors").addPreferenceChangeListener(new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                String[] stringArray = annotationKeyPrefixes;
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String prefix = stringArray[n2];
                    if (event.getKey().startsWith(prefix)) {
                        final String scopeSelector = "override." + prefix;
                        if (event.getNewValue() == null && event.getKey().endsWith("Color")) {
                            UIJob job = new UIJob("Restoring overrides of Annotation"){

                                public IStatus runInUIThread(IProgressMonitor monitor) {
                                    ThemeRule rule = ThemeManager.this.getCurrentTheme().getRuleForSelector((IScopeSelector)new ScopeSelector(scopeSelector));
                                    if (rule != null) {
                                        ThemeManager.this.getCurrentTheme().remove(rule);
                                    }
                                    return Status.OK_STATUS;
                                }
                            };
                            EclipseUtil.setSystemForJob((Job)job);
                            job.setPriority(50);
                            job.schedule();
                            break;
                        }
                        if (ThemeManager.this.getCurrentTheme().hasEntry(scopeSelector)) break;
                        int index = ThemeManager.this.getCurrentTheme().getTokens().size();
                        ThemeManager.this.getCurrentTheme().addNewRule(index, "Annotation Override - " + prefix, new ScopeSelector(scopeSelector), null);
                        break;
                    }
                    ++n2;
                }
            }
        });
    }

    public static synchronized ThemeManager instance() {
        if (fgInstance == null) {
            fgInstance = new ThemeManager();
        }
        return fgInstance;
    }

    private TextAttribute getTextAttribute(String name) {
        if (this.getCurrentTheme() != null) {
            return this.getCurrentTheme().getTextAttribute(name);
        }
        return new TextAttribute(ThemePlugin.getDefault().getColorManager().getColor(new RGB(255, 255, 255)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Theme getCurrentTheme() {
        if (this.fCurrentTheme == null) {
            ThemeManager themeManager = this;
            synchronized (themeManager) {
                String activeThemeName = Platform.getPreferencesService().getString("com.aptana.theme", "ACTIVE_THEME", "Light Studio", null);
                if (activeThemeName != null) {
                    this.fCurrentTheme = this.getTheme(activeThemeName);
                }
                if (this.fCurrentTheme == null && !this.getThemeNames().isEmpty()) {
                    this.fCurrentTheme = this.getTheme(this.getThemeNames().iterator().next());
                }
                if (this.fCurrentTheme != null) {
                    this.setCurrentTheme(this.fCurrentTheme);
                }
            }
        }
        return this.fCurrentTheme;
    }

    @Override
    public void setCurrentTheme(Theme theme) {
        this.fCurrentTheme = theme;
        this.setSearchResultColor(theme);
        this.setAnnotationColorsToMatchTheme(theme);
        this.setAptanaEditorColorsToMatchTheme(theme);
        this.setCompareColors("com.aptana.editor.common", true);
        this.setCompareColors("org.eclipse.ui.editors", ThemePlugin.applyToAllEditors());
        UIUtils.runInUIThread((Runnable)new Runnable(){

            public void run() {
                ThemeManager.this.notifyThemeChangeListeners(ThemeManager.this.fCurrentTheme);
            }
        });
        this.forceFontsUpToDate();
    }

    private void setCompareColors(String nodeName, boolean override) {
        IEclipsePreferences instancePrefs = InstanceScope.INSTANCE.getNode(nodeName);
        if (override) {
            RGB bg = this.getCurrentTheme().getBackground();
            RGB inverted = new RGB(255 - bg.red, 255 - bg.green, 255 - bg.blue);
            JFaceResources.getColorRegistry().put("INCOMING_COLOR", inverted);
            JFaceResources.getColorRegistry().put("OUTGOING_COLOR", inverted);
            instancePrefs.put("INCOMING_COLOR", StringConverter.asString((RGB)inverted));
            instancePrefs.put("OUTGOING_COLOR", StringConverter.asString((RGB)inverted));
        } else {
            RGB rgb2;
            IEclipsePreferences defPrefs = DefaultScope.INSTANCE.getNode(nodeName);
            String value = defPrefs.get("OUTGOING_COLOR", null);
            if (value != null) {
                try {
                    rgb2 = StringConverter.asRGB((String)value);
                    if (rgb2 != null) {
                        JFaceResources.getColorRegistry().put("OUTGOING_COLOR", rgb2);
                    }
                }
                catch (DataFormatException rgb2) {
                    // empty catch block
                }
            }
            if ((value = defPrefs.get("INCOMING_COLOR", null)) != null) {
                try {
                    rgb2 = StringConverter.asRGB((String)value);
                    if (rgb2 != null) {
                        JFaceResources.getColorRegistry().put("INCOMING_COLOR", rgb2);
                    }
                }
                catch (DataFormatException dataFormatException) {
                    // empty catch block
                }
            }
            instancePrefs.remove("INCOMING_COLOR");
            instancePrefs.remove("OUTGOING_COLOR");
        }
        try {
            instancePrefs.flush();
        }
        catch (BackingStoreException e) {
            IdeLog.logError((Plugin)ThemePlugin.getDefault(), (Throwable)e);
        }
    }

    private void setSearchResultColor(Theme theme) {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.search");
        prefs.put("org.eclipse.search.potentialMatch.fgColor", ThemeManager.toString(theme.getSearchResultColor()));
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            IdeLog.logError((Plugin)ThemePlugin.getDefault(), (Throwable)e);
        }
    }

    private void forceFontsUpToDate() {
        final String[] fontIds = new String[]{"com.aptana.explorer.font", "org.eclipse.jface.textfont", "org.eclipse.ui.workbench.texteditor.blockSelectionModeFont"};
        UIUtils.getDisplay().asyncExec(new Runnable(){

            public void run() {
                String[] stringArray = fontIds;
                int n = fontIds.length;
                int n2 = 0;
                while (n2 < n) {
                    String fdString;
                    String fontId = stringArray[n2];
                    Font fFont = JFaceResources.getFontRegistry().get(fontId);
                    Font existing = JFaceResources.getFont((String)fontId);
                    String existingString = "";
                    if (!existing.isDisposed()) {
                        existingString = PreferenceConverter.getStoredRepresentation((FontData[])existing.getFontData());
                    }
                    if (!existingString.equals(fdString = PreferenceConverter.getStoredRepresentation((FontData[])fFont.getFontData()))) {
                        JFaceResources.getFontRegistry().put(fontId, fFont.getFontData());
                    }
                    ++n2;
                }
            }
        });
    }

    private void notifyThemeChangeListeners(Theme theme) {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("com.aptana.theme");
        prefs.put("ACTIVE_THEME", theme.getName());
        prefs.putLong("THEME_CHANGED", System.currentTimeMillis());
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            IdeLog.logError((Plugin)ThemePlugin.getDefault(), (Throwable)e);
        }
    }

    private void setAptanaEditorColorsToMatchTheme(Theme theme) {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("com.aptana.editor.common");
        prefs.putBoolean("AbstractTextEditor.Color.SelectionForeground.SystemDefault", false);
        prefs.put("AbstractTextEditor.Color.SelectionForeground", ThemeManager.toString(theme.getForeground()));
        prefs.putBoolean("AbstractTextEditor.Color.Background.SystemDefault", false);
        prefs.put("AbstractTextEditor.Color.Background", ThemeManager.toString(theme.getBackground()));
        prefs.putBoolean("AbstractTextEditor.Color.Foreground.SystemDefault", false);
        prefs.put("AbstractTextEditor.Color.Foreground", ThemeManager.toString(theme.getForeground()));
        prefs.put("currentLineColor", ThemeManager.toString(theme.getLineHighlightAgainstBG()));
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            IdeLog.logError((Plugin)ThemePlugin.getDefault(), (Throwable)e);
        }
    }

    private void setAnnotationColorsToMatchTheme(Theme theme) {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.ui.editors");
        if (!theme.hasEntry("override.searchResultIndication")) {
            prefs.put("searchResultIndicationColor", ThemeManager.toString(theme.getSearchResultColor()));
        }
        if (!theme.hasEntry("override.xmlTagPairOccurrenceIndication")) {
            prefs.putBoolean("xmlTagPairOccurrenceIndicationHighlighting", false);
            prefs.putBoolean("xmlTagPairOccurrenceIndication", true);
            prefs.put("xmlTagPairOccurrenceIndicationColor", ThemeManager.toString(theme.getOccurenceHighlightColor()));
            prefs.put("xmlTagPairOccurrenceIndicationTextStyle", "BOX");
        }
        if (!theme.hasEntry("override.htmlTagPairOccurrenceIndication")) {
            prefs.putBoolean("htmlTagPairOccurrenceIndicationHighlighting", false);
            prefs.putBoolean("htmlTagPairOccurrenceIndication", true);
            prefs.put("htmlTagPairOccurrenceIndicationColor", ThemeManager.toString(theme.getOccurenceHighlightColor()));
            prefs.put("htmlTagPairOccurrenceIndicationTextStyle", "BOX");
        }
        if (!theme.hasEntry("override.rubyBlockPairOccurrenceIndication")) {
            prefs.putBoolean("rubyBlockPairOccurrenceIndicationHighlighting", false);
            prefs.putBoolean("rubyBlockPairOccurrenceIndication", true);
            prefs.put("rubyBlockPairOccurrenceIndicationColor", ThemeManager.toString(theme.getOccurenceHighlightColor()));
            prefs.put("rubyBlockPairOccurrenceIndicationTextStyle", "BOX");
        }
        if (Platform.getPreferencesService().getBoolean("org.python.pydev.red_core", "PYDEV_USE_APTANA_THEMES", true, null) && !theme.hasEntry("override.pydevOccurrenceIndication")) {
            MarkerAnnotationPreferences preferences = new MarkerAnnotationPreferences();
            AnnotationPreference pydevOccurPref = null;
            for (Object obj : preferences.getAnnotationPreferences()) {
                AnnotationPreference pref = (AnnotationPreference)obj;
                Object type = pref.getAnnotationType();
                if (!"com.python.pydev.occurrences".equals(type)) continue;
                pydevOccurPref = pref;
            }
            if (pydevOccurPref != null) {
                if (pydevOccurPref.getTextStylePreferenceKey() != null) {
                    prefs.putBoolean("pydevOccurrenceHighlighting", false);
                    prefs.putBoolean("pydevOccurrenceIndication", true);
                    prefs.put("pydevOccurrenceIndicationColor", ThemeManager.toString(theme.getOccurenceHighlightColor()));
                    prefs.put("pydevOccurrenceIndicationTextStyle", "BOX");
                } else {
                    prefs.putBoolean("pydevOccurrenceHighlighting", true);
                    prefs.putBoolean("pydevOccurrenceIndication", true);
                    prefs.put("pydevOccurrenceIndicationColor", ThemeManager.toString(theme.getSearchResultColor()));
                }
            }
        }
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            IdeLog.logError((Plugin)ThemePlugin.getDefault(), (Throwable)e);
        }
    }

    private static String toString(RGB selection) {
        return StringConverter.asString((RGB)selection);
    }

    @Override
    public Theme getTheme(String name) {
        Theme loaded = null;
        try {
            loaded = this.loadUserTheme(name);
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)ThemePlugin.getDefault(), (String)MessageFormat.format("Failed to load theme {0} from preferences.", name), (Throwable)e);
        }
        if (loaded != null) {
            return loaded;
        }
        try {
            return this.loadBuiltinTheme(name);
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)ThemePlugin.getDefault(), (String)MessageFormat.format("Failed to load theme {0} from builtins.", name), (Throwable)e);
            return null;
        }
    }

    @Override
    public synchronized Set<String> getThemeNames() {
        if (this.fThemeNames == null) {
            IScopeContext[] scopes;
            this.fThemeNames = new HashSet<String>();
            this.fThemeNames.addAll(this.getBuiltinThemeNames());
            IScopeContext[] iScopeContextArray = scopes = new IScopeContext[]{InstanceScope.INSTANCE, DefaultScope.INSTANCE};
            int n = scopes.length;
            int n2 = 0;
            while (n2 < n) {
                IScopeContext scope = iScopeContextArray[n2];
                IEclipsePreferences prefs = scope.getNode("com.aptana.theme");
                Preferences preferences = prefs.node(THEMES_NODE);
                try {
                    String[] themeNames = preferences.keys();
                    this.fThemeNames.addAll(Arrays.asList(themeNames));
                }
                catch (BackingStoreException e) {
                    IdeLog.logError((Plugin)ThemePlugin.getDefault(), (Throwable)e);
                }
                ++n2;
            }
        }
        return this.fThemeNames;
    }

    private Theme loadUserTheme(String themeName) {
        block36: {
            Theme theme;
            InputStream byteStream = null;
            try {
                byte[] array = Platform.getPreferencesService().getByteArray("com.aptana.theme", "themes/" + themeName, null, null);
                if (array == null) {
                    return null;
                }
                byteStream = new ByteArrayInputStream(array);
                OrderedProperties props = new OrderedProperties();
                props.load(byteStream);
                if (!props.containsKey("name")) {
                    IdeLog.logWarning((Plugin)ThemePlugin.getDefault(), (String)MessageFormat.format("User theme {0} de-serialized, but was left Base64 encoded. Manually decoding and trying to load.", themeName));
                    byteStream = new ByteArrayInputStream(Base64.decode((byte[])array));
                    props = new OrderedProperties();
                    props.load(byteStream);
                }
                theme = new Theme(ThemePlugin.getDefault().getColorManager(), props);
            }
            catch (IllegalArgumentException iae) {
                String xml = Platform.getPreferencesService().getString("com.aptana.theme", "themes/" + themeName, null, null);
                if (xml == null) break block36;
                ByteArrayInputStream stream = null;
                try {
                    stream = new ByteArrayInputStream(xml.getBytes("UTF-8"));
                    OrderedProperties props = new OrderedProperties();
                    props.loadFromXML(stream);
                    Theme theme2 = new Theme(ThemePlugin.getDefault().getColorManager(), props);
                    theme2.save();
                    Theme theme3 = theme2;
                    return theme3;
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)ThemePlugin.getDefault(), (Throwable)e);
                    break block36;
                }
                finally {
                    if (stream != null) {
                        try {
                            ((InputStream)stream).close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            catch (IOException e) {
                IdeLog.logError((Plugin)ThemePlugin.getDefault(), (Throwable)e);
                break block36;
            }
            finally {
                if (byteStream != null) {
                    try {
                        byteStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return theme;
        }
        return null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private OrderedProperties getBuiltinThemeProperties(String themeName) {
        Collection<URL> urls = this.getBuiltinThemeURLs();
        if (CollectionsUtil.isEmpty(urls)) {
            return null;
        }
        for (URL url : urls) {
            try {
                InputStream stream = FileLocator.toFileURL((URL)url).openStream();
                try {
                    OrderedProperties props = new OrderedProperties();
                    props.load(stream);
                    String loadedName = props.getProperty("name");
                    if (!themeName.equals(loadedName)) continue;
                    String multipleThemeExtends = props.getProperty("extends_theme");
                    if (multipleThemeExtends != null) {
                        String[] pieces;
                        OrderedProperties newProperties = new OrderedProperties();
                        String[] stringArray = pieces = multipleThemeExtends.split(",");
                        int n = pieces.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String themeExtends = stringArray[n2];
                            OrderedProperties extended = this.getBuiltinThemeProperties(themeExtends);
                            if (extended == null) {
                                throw new IllegalStateException(MessageFormat.format(Messages.ThemeManager_ERR_NoThemeFound, themeExtends, loadedName));
                            }
                            newProperties.putAll((Map<?, ?>)extended);
                            ++n2;
                        }
                        newProperties.putAll((Map<?, ?>)props);
                        newProperties.remove("extends_theme");
                        Assert.isTrue((boolean)newProperties.get("name").equals(themeName));
                        OrderedProperties orderedProperties = newProperties;
                        return orderedProperties;
                    }
                    OrderedProperties orderedProperties = props;
                    return orderedProperties;
                }
                finally {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)ThemePlugin.getDefault(), (String)url.toString(), (Throwable)e);
            }
        }
        return null;
    }

    private synchronized Set<String> getBuiltinThemeNames() {
        if (this.fBuiltins == null) {
            this.fBuiltins = new HashSet<String>();
            Collection<URL> urls = this.getBuiltinThemeURLs();
            if (urls == null || urls.isEmpty()) {
                return this.fBuiltins;
            }
            for (URL url : urls) {
                InputStream stream = null;
                try {
                    try {
                        stream = FileLocator.toFileURL((URL)url).openStream();
                        OrderedProperties props = new OrderedProperties();
                        props.load(stream);
                        String loadedName = props.getProperty("name");
                        if (loadedName != null && !loadedName.startsWith("abstract_theme")) {
                            this.fBuiltins.add(loadedName);
                        }
                    }
                    catch (Exception e) {
                        IdeLog.logError((Plugin)ThemePlugin.getDefault(), (Throwable)e);
                        try {
                            if (stream == null) continue;
                            stream.close();
                        }
                        catch (IOException iOException) {}
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    if (stream == null) continue;
                    stream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return this.fBuiltins;
    }

    private Collection<URL> getBuiltinThemeURLs() {
        ThemePlugin themePlugin = ThemePlugin.getDefault();
        if (themePlugin == null) {
            return Collections.emptyList();
        }
        Bundle bundle = themePlugin.getBundle();
        if (bundle == null) {
            return Collections.emptyList();
        }
        ArrayList<URL> collection = new ArrayList<URL>();
        Enumeration enumeration = bundle.findEntries(THEMES_NODE, "*.properties", false);
        while (enumeration.hasMoreElements()) {
            collection.add((URL)enumeration.nextElement());
        }
        collection.trimToSize();
        return collection;
    }

    public Theme loadBuiltinTheme(String themeName) {
        OrderedProperties properties = this.getBuiltinThemeProperties(themeName);
        if (properties == null) {
            return null;
        }
        return this.loadBuiltinTheme(properties);
    }

    private Theme loadBuiltinTheme(Properties props) {
        try {
            return new Theme(ThemePlugin.getDefault().getColorManager(), props);
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)ThemePlugin.getDefault(), (Throwable)e);
            return null;
        }
    }

    @Override
    public IToken getToken(String scope) {
        return new Token((Object)this.getTextAttribute(scope));
    }

    @Override
    public void addTheme(Theme newTheme) {
        newTheme.save();
        this.getThemeNames().add(newTheme.getName());
    }

    @Override
    public void removeTheme(Theme theme) {
        Theme activeTheme = this.getCurrentTheme();
        this.getThemeNames().remove(theme.getName());
        if (activeTheme.getName().equals(theme.getName())) {
            this.setCurrentTheme(this.getTheme(this.getThemeNames().iterator().next()));
        }
    }

    @Override
    public boolean isBuiltinTheme(String themeName) {
        return this.getBuiltinThemeNames().contains(themeName);
    }

    @Override
    public IStatus validateThemeName(String name) {
        if (StringUtil.isEmpty((String)name)) {
            return new Status(4, "com.aptana.theme", Messages.ThemeManager_NameNonEmptyMsg);
        }
        if (this.getThemeNames().contains(name.trim())) {
            return new Status(4, "com.aptana.theme", Messages.ThemeManager_NameAlreadyExistsMsg);
        }
        return Status.OK_STATUS;
    }
}

